<?php

include_once('interface.IConectorServisim.php');
class ConectorServisim implements IConectorServisim {
	
	public function __construct(){
		$this->wsdl = null;
		$this->user = null;
		$this->pass = null;
		$this->nameSpace = null;
		$this->method = null;
	}
	
	public function establecerEndPoint($endPoint){
		$this->wsdl = $endPoint.'?wsdl';
	}
	
	public function establecerSoapAction($nameSpace, $method){
		$this->nameSpace = $nameSpace;
		$partes=explode('/',$method);
		$this->method = $partes[1];
	}
	
	public function establecerAcceso($user, $pass){
		$this->user = $user;
		$this->pass = $pass;
	}
	
	public function crearPeticion(){
		$this->request = new StdClass();
		$this->request->User = $this->user;
		$this->request->Pass = $this->pass;
	}
	
	public function asignarEnPeticion($name, $value){
		$this->request->$name = $value;
	}
	
	public function consumirServicio(){
		try{		
			$cliente = new SoapClient($this->wsdl);
			$result = null;
			$methodRequest = $this->method;
			$result = $cliente->$methodRequest(array('request'=>$this->request));
			$methodResult = $this->method.'Result';
			$this->response = $result->$methodResult;
			$this->request = null;
		}
		catch (Exception $ex) {
			throw new Exception('Error al conectar con servicio web. '.$ex->getMessage());
		}
	}
	
	public function obtenerDeRespuesta($name){
		return $this->response->$name;
	}
}

?>