<?php
//Incluimos funcin de conexin.
include_once('class.ConectorServisim.php');
try {
	//1. Creamos nuevo objeto de conexin.
	$conector = new ConectorServisim();
	//1.1 Establecemos EndPoint de Servisim.
	$conector->establecerEndPoint('http://201.150.37.20:8080/ServisimTest/TimbradoCFDi');
	//1.2 Establecemos la accin a realizar.
	$conector->establecerSoapAction('http://controller.timbrado.ws.servisim.com/', 'timbrarCFDi');
	//1.3 Establecemos los datos de acceso al servicio web.
	$conector->establecerAcceso('1', 'servisim');
	//2. Crear peticin
	$conector->crearPeticion();
	//3. Asignamos datos a la peticin.
	//3.1 Asignamos Identificador UNICO del CFDi. sugerencia SERIE+FOLIO
	$conector->asignarEnPeticion('Id', 'FAC-001');
	//3.2 Asignamos el Contenido del XML ya sellado por el Emisor.
	$conector->asignarEnPeticion('Xml', '<?xml version="1.0" encoding="UTF-8"?>
<cfdi:Comprobante xmlns:cfdi="http://www.sat.gob.mx/cfd/3" xmlns:tfd="http://www.sat.gob.mx/TimbreFiscalDigital" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" LugarExpedicion="Mxico" metodoDePago="efectivo" tipoDeComprobante="ingreso" total="0.174" subTotal="0.15" certificado="MIIEdDCCA1ygAwIBAgIUMjAwMDEwMDAwMDAxMDAwMDU4NjcwDQYJKoZIhvcNAQEFBQAwggFvMRgwFgYDVQQDDA9BLkMuIGRlIHBydWViYXMxLzAtBgNVBAoMJlNlcnZpY2lvIGRlIEFkbWluaXN0cmFjacOzbiBUcmlidXRhcmlhMTgwNgYDVQQLDC9BZG1pbmlzdHJhY2nDs24gZGUgU2VndXJpZGFkIGRlIGxhIEluZm9ybWFjacOzbjEpMCcGCSqGSIb3DQEJARYaYXNpc25ldEBwcnVlYmFzLnNhdC5nb2IubXgxJjAkBgNVBAkMHUF2LiBIaWRhbGdvIDc3LCBDb2wuIEd1ZXJyZXJvMQ4wDAYDVQQRDAUwNjMwMDELMAkGA1UEBhMCTVgxGTAXBgNVBAgMEERpc3RyaXRvIEZlZGVyYWwxEjAQBgNVBAcMCUNveW9hY8OhbjEVMBMGA1UELRMMU0FUOTcwNzAxTk4zMTIwMAYJKoZIhvcNAQkCDCNSZXNwb25zYWJsZTogSMOpY3RvciBPcm5lbGFzIEFyY2lnYTAeFw0xMjA3MjcxNzAyMDBaFw0xNjA3MjcxNzAyMDBaMIHbMSkwJwYDVQQDEyBBQ0NFTSBTRVJWSUNJT1MgRU1QUkVTQVJJQUxFUyBTQzEpMCcGA1UEKRMgQUNDRU0gU0VSVklDSU9TIEVNUFJFU0FSSUFMRVMgU0MxKTAnBgNVBAoTIEFDQ0VNIFNFUlZJQ0lPUyBFTVBSRVNBUklBTEVTIFNDMSUwIwYDVQQtExxBQUEwMTAxMDFBQUEgLyBIRUdUNzYxMDAzNFMyMR4wHAYDVQQFExUgLyBIRUdUNzYxMDAzTURGUk5OMDkxETAPBgNVBAsTCFVuaWRhZCAxMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC2TTQSPONBOVxpXv9wLYo8jezBrb34i/tLx8jGdtyy27BcesOav2c1NS/Gdv10u9SkWtwdy34uRAVe7H0a3VMRLHAkvp2qMCHaZc4T8k47Jtb9wrOEh/XFS8LgT4y5OQYo6civfXXdlvxWU/gdM/e6I2lg6FGorP8H4GPAJ/qCNwIDAQABox0wGzAMBgNVHRMBAf8EAjAAMAsGA1UdDwQEAwIGwDANBgkqhkiG9w0BAQUFAAOCAQEATxMecTpMbdhSHo6KVUg4QVF4Op2IBhiMaOrtrXBdJgzGotUFcJgdBCMjtTZXSlq1S4DG1jr8p4NzQlzxsdTxaB8nSKJ4KEMgIT7E62xRUj15jI49qFz7f2uMttZLNThipunsN/NF1XtvESMTDwQFvas/Ugig6qwEfSZc0MDxMpKLEkEePmQwtZD+zXFSMVa6hmOu4M+FzGiRXbj4YJXn9Myjd8xbL/c+9UIcrYoZskxDvMxc6/6M3rNNDY3OFhBK+V/sPMzWWGt8S1yjmtPfXgFs1t65AZ2hcTwTAuHrKwDatJ1ZPfa482ZBROAAX1waz7WwXp0gso7sDCm2/yUVww==" noCertificado="20001000000100005867" formaDePago="PAGO EN UNA SOLA EXHIBICION" sello="jU5Yg6YgYDiYv0PVqFMYN0Rlx1Tc/ekc+vNWF0HIlgov1HwGyXfrNZNH2KlH4UfXdpR4bYYJKCmxOq3wtyqkzGHQaconVTq4P9h9PrnbTMGz1VqCTGpZZKfx9pyOviB4xOsiABJTD4BoXu8SC0klP80dBnPVxPcTg9eOmUPoSy8=" fecha="2012-09-11T15:43:22" version="3.2" xsi:schemaLocation="http://www.sat.gob.mx/cfd/3  http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv32.xsd">
    <cfdi:Emisor nombre="Servisim S.A. de C.V." rfc="AAA010101AAA">
        <cfdi:DomicilioFiscal codigoPostal="07630" pais="Mexico" estado="Distrito Federal" municipio="Gustavo A. Madero" colonia="San Jose de la Escalera" noExterior="1829" calle="Calzada Vallejo"/>
        <cfdi:ExpedidoEn codigoPostal="07630" pais="Mexico" estado="Distrito Federal" municipio="Gustavo A. Madero" colonia="San Jose de la Escalera" noExterior="1829" calle="Calzada Vallejo"/>
        <cfdi:RegimenFiscal Regimen="simplificado"/>
    </cfdi:Emisor>
    <cfdi:Receptor nombre="Cliente General" rfc="XAXX010101000">
        <cfdi:Domicilio pais="Mxico"/>
    </cfdi:Receptor>
    <cfdi:Conceptos>
        <cfdi:Concepto importe="0.15" valorUnitario="0.15" descripcion="1 Timbre" unidad="PZA" cantidad="1"/>
    </cfdi:Conceptos>
    <cfdi:Impuestos>
        <cfdi:Traslados>
            <cfdi:Traslado importe="0.024" tasa="16.0" impuesto="IVA"/>
        </cfdi:Traslados>
    </cfdi:Impuestos>
</cfdi:Comprobante>');
	//4. consumir servicio
	$conector->consumirServicio();
	//5. Obtener datos de la respuesta
	echo 'ID ERROR: ';
	echo $conector->obtenerDeRespuesta('IdError');
	echo '<br/>ERROR: ';
	echo $conector->obtenerDeRespuesta('Error');
	echo '<br/>UUID: ';
	echo $conector->obtenerDeRespuesta('Uuid');
	echo '<br/>FECHA TIMBRE: ';
	echo $conector->obtenerDeRespuesta('FechaTimbre');
	echo '<br/>XML LENGTH :';
	//5.5 La variable es muy grande y echo no la muestra, para efectos de prueba mostramos su tamao
	echo strlen($conector->obtenerDeRespuesta('Xml'));
}
catch (Exception $ex){
	echo $ex->getMessage();
}

?>